/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.stevekung.fishofthieves.FishOfThieves;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.frog.Tadpole;

public class HeadphoneModel<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(FishOfThieves.id("headphone"), "main");
    private final ModelPart headphone;

    public HeadphoneModel(ModelPart part) {
        this.headphone = part.getChild("headphone");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("headphone", CubeListBuilder.create().texOffs(0, 3).addBox(1.5f, -7.5f, -1.0f, 1.0f, 2.0f, 2.0f).texOffs(0, 3).addBox(-2.5f, -7.5f, -1.0f, 1.0f, 2.0f, 2.0f).texOffs(0, 0).addBox(-2.0f, -9.5f, -0.5f, 4.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)16, (int)16);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int packedColor) {
        this.headphone.render(poseStack, buffer, packedLight, packedOverlay, packedColor);
    }

    public static interface Scaleable<T extends Entity> {
        public static final Scaleable<Cod> COD = (entity, poseStack) -> poseStack.translate(0.0f, 0.25f, -0.05f);
        public static final Scaleable<Salmon> SALMON = (entity, poseStack) -> {
            poseStack.scale(1.5f, 1.5f, 1.5f);
            poseStack.translate(0.0f, -0.275f, 0.0f);
        };
        public static final Scaleable<Pufferfish> PUFFERFISH = (entity, poseStack) -> {
            float y = 0.0f;
            switch (entity.getPuffState()) {
                case 0: {
                    y = 0.25f;
                    poseStack.scale(1.25f, 1.0f, 0.75f);
                    break;
                }
                case 1: {
                    y = -0.275f;
                    poseStack.scale(1.75f, 1.5f, 1.5f);
                    break;
                }
                case 2: {
                    y = -0.55f;
                    poseStack.scale(3.0f, 2.0f, 2.0f);
                }
            }
            poseStack.translate(0.0f, y, -0.025f);
        };
        public static final Scaleable<TropicalFish> TROPICAL_FISH = (entity, poseStack) -> {
            TropicalFish.Base baseVariant = entity.getVariant().base();
            float y = 0.0f;
            float z = 0.0f;
            if (baseVariant == TropicalFish.Base.SMALL) {
                y = 0.275f;
                z = -0.08f;
            } else {
                y = -0.325f;
                z = -0.1f;
                poseStack.scale(1.0f, 1.5f, 1.0f);
            }
            poseStack.translate(0.0f, y, z);
        };
        public static final Scaleable<Tadpole> TADPOLE = (entity, poseStack) -> {
            poseStack.scale(1.1f, 1.1f, 1.1f);
            poseStack.translate(0.0f, 0.15f, -0.08f);
        };

        public void scale(T var1, PoseStack var2);
    }
}

